/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.content.environmentSystem;

import cofh.core.init.CoreParticles;
import com.c2h6s.etshtinker.init.etshtinkerParticleType;
import com.hoshino.cti.Capabilitiess.IElectricShielding;
import com.hoshino.cti.Capabilitiess.IFreezeShielding;
import com.hoshino.cti.Capabilitiess.IPressureShielding;
import com.hoshino.cti.Capabilitiess.IScorchShielding;
import com.hoshino.cti.Capabilitiess.ctiCapabilities;
import com.hoshino.cti.content.environmentSystem.EDamageSource;
import com.hoshino.cti.content.environmentSystem.IEnvironmentalSource;
import com.hoshino.cti.netwrok.CtiPacketHandler;
import com.hoshino.cti.netwrok.packet.PFrozenValueSync;
import com.hoshino.cti.netwrok.packet.PIonizeValueSync;
import com.hoshino.cti.netwrok.packet.PPressureValueSync;
import com.hoshino.cti.netwrok.packet.PScorchValueSync;
import com.hoshino.cti.register.CtiAttributes;
import com.hoshino.cti.util.BiomeUtil;
import com.hoshino.cti.util.CtiTagkey;
import com.hoshino.cti.util.ILivingEntityMixin;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class EnvironmentalHandler {
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final String IONIZE_AMOUNT = "environmental.ionize";
    public static final String SCORCH_AMOUNT = "environmental.scorch";
    public static final String FROZEN_AMOUNT = "environmental.frozen";
    public static final String PRESSURE_AMOUNT = "environmental.pressure";
    public static final float baseDamage = 10.0f;
    public static final float baseMultiplier = 0.05f;

    public static boolean hurtEntity(LivingEntity living, DamageSource source, float amount) {
        if (source instanceof IEnvironmentalSource) {
            IEnvironmentalSource environmental = (IEnvironmentalSource)source;
            if (environmental.fromBiomes()) {
                return ((ILivingEntityMixin)living).cti$strictHurt(source, amount);
            }
            double protection = 0.0;
            AttributeInstance instance = living.m_21051_(environmental.getResistAttribute());
            if (instance != null) {
                protection = instance.m_22135_();
            }
            double multiplier = Math.max(0.0, (double)environmental.getLevel() - protection);
            return ((ILivingEntityMixin)living).cti$strictHurt(source, (float)((double)amount * multiplier));
        }
        return false;
    }

    public static void livingTick(LivingEntity living) {
        Level level = living.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Holder biome = level2.m_204166_(living.m_20183_());
            float ionizeResistance = EnvironmentalHandler.getIonizeResistance(living);
            float scorchResistance = EnvironmentalHandler.getScorchResistance(living);
            float frozenResistance = EnvironmentalHandler.getFrozenResistance(living);
            float pressureResistance = EnvironmentalHandler.getPressureResistance(living);
            float ionizeLevel = BiomeUtil.getBiomeIonizeLevel((Holder<Biome>)biome) - ionizeResistance;
            float scorchLevel = BiomeUtil.getBiomeScorchLevel((Holder<Biome>)biome) - scorchResistance - BiomeUtil.getBiomeFreezeLevel((Holder<Biome>)biome);
            float frozenLevel = BiomeUtil.getBiomeFreezeLevel((Holder<Biome>)biome) - frozenResistance - BiomeUtil.getBiomeScorchLevel((Holder<Biome>)biome);
            float pressureLevel = BiomeUtil.getBiomePressureLevel((Holder<Biome>)biome) - pressureResistance;
            if (living.m_21233_() > 5000.0f && !(living instanceof Player)) {
                ionizeLevel = -2.0f;
                scorchLevel = -2.0f;
                frozenLevel = -2.0f;
                pressureLevel = -2.0f;
            }
            if (living.m_6084_()) {
                ServerLevel serverLevel;
                Level level3;
                float harmLevel;
                ServerPlayer player;
                int value = EnvironmentalHandler.getScorchValue(living);
                int volume = EnvironmentalHandler.getEnvironmentalVolume(living);
                float baseBuildUp = (float)volume / 100.0f;
                int maxValue = (int)(scorchLevel * 4.0f) * EnvironmentalHandler.getEnvironmentalVolume(living) / 4;
                float baseDecrease = (float)volume / 100.0f;
                float toAdd = 0.0f;
                if (scorchLevel > 0.0f && value < maxValue) {
                    toAdd = Math.max(1.0f, baseBuildUp * scorchLevel);
                    int added = (int)Math.min((float)(maxValue - value), toAdd);
                    EnvironmentalHandler.addScorchValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PScorchValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (scorchLevel <= 0.0f && value > 0) {
                    toAdd = Math.min(-1.0f, baseDecrease * scorchLevel);
                    int added = (int)Math.max((float)(-value), toAdd);
                    EnvironmentalHandler.addScorchValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PScorchValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (living instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)living;
                    CtiPacketHandler.sendToPlayer(new PScorchValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player2);
                }
                toAdd = 0.0f;
                value = EnvironmentalHandler.getFrozenValue(living);
                maxValue = (int)(frozenLevel * 4.0f) * volume / 4;
                if (frozenLevel > 0.0f && value < maxValue) {
                    toAdd = Math.max(1.0f, baseBuildUp * frozenLevel);
                    int added = (int)Math.min((float)(maxValue - value), toAdd);
                    EnvironmentalHandler.addFrozenValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PFrozenValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (frozenLevel <= 0.0f && value > 0) {
                    toAdd = Math.min(-1.0f, baseDecrease * frozenLevel);
                    int added = (int)Math.max((float)(-value), toAdd);
                    EnvironmentalHandler.addFrozenValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PFrozenValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (living instanceof ServerPlayer) {
                    ServerPlayer player3 = (ServerPlayer)living;
                    CtiPacketHandler.sendToPlayer(new PFrozenValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player3);
                }
                toAdd = 0.0f;
                value = EnvironmentalHandler.getPressureValue(living);
                maxValue = (int)(frozenLevel * 4.0f) * volume / 4;
                if (pressureLevel > 0.0f && value < maxValue) {
                    toAdd = Math.max(1.0f, baseBuildUp * pressureLevel);
                    int added = (int)Math.min((float)(maxValue - value), toAdd);
                    EnvironmentalHandler.addPressureValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PPressureValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (pressureLevel <= 0.0f && value > 0) {
                    toAdd = Math.min(-1.0f, baseDecrease * pressureLevel);
                    int added = (int)Math.max((float)(-value), toAdd);
                    EnvironmentalHandler.addPressureValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PPressureValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (living instanceof ServerPlayer) {
                    ServerPlayer player4 = (ServerPlayer)living;
                    CtiPacketHandler.sendToPlayer(new PPressureValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player4);
                }
                toAdd = 0.0f;
                value = EnvironmentalHandler.getIonizeValue(living);
                maxValue = (int)(ionizeLevel * 4.0f) * volume / 4;
                if (ionizeLevel > 0.0f && value < maxValue) {
                    toAdd = Math.max(1.0f, baseBuildUp * ionizeLevel);
                    int added = (int)Math.min((float)(maxValue - value), Math.max(1.0f, baseBuildUp * ionizeLevel));
                    EnvironmentalHandler.addIonizeValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PIonizeValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (ionizeLevel <= 0.0f && value > 0) {
                    toAdd = Math.min(-1.0f, baseDecrease * ionizeLevel);
                    int added = (int)Math.max((float)(-value), Math.min(-1.0f, baseDecrease * ionizeLevel));
                    EnvironmentalHandler.addIonizeValue(living, added);
                    if (living instanceof ServerPlayer) {
                        player = (ServerPlayer)living;
                        CtiPacketHandler.sendToPlayer(new PIonizeValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player);
                    }
                } else if (living instanceof ServerPlayer) {
                    ServerPlayer player5 = (ServerPlayer)living;
                    CtiPacketHandler.sendToPlayer(new PIonizeValueSync((float)(value * 100) / (float)volume, toAdd * 100.0f / (float)volume), player5);
                }
                if ((double)pressureLevel >= 1.5) {
                    EnvironmentalHandler.hurtEntity(living, EDamageSource.pressure(true, 10), Float.MAX_VALUE);
                }
                if ((double)(harmLevel = (float)EnvironmentalHandler.getScorchValue(living) / (float)EnvironmentalHandler.getEnvironmentalVolume(living)) > 0.5) {
                    EnvironmentalHandler.hurtEntity(living, EDamageSource.scorched(true, (int)harmLevel), harmLevel * 10.0f);
                    EnvironmentalHandler.postScorchEffect(harmLevel, living);
                    level3 = living.f_19853_;
                    if (level3 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level3;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(harmLevel * 10.0f), 0.0, 0.0, 0.0, 0.25);
                    }
                }
                if ((double)(harmLevel = (float)EnvironmentalHandler.getFrozenValue(living) / (float)EnvironmentalHandler.getEnvironmentalVolume(living)) > 0.25) {
                    EnvironmentalHandler.hurtEntity(living, EDamageSource.frozen(true, (int)harmLevel), harmLevel * 10.0f * 0.5f);
                    EnvironmentalHandler.postFrozenEffect(harmLevel, living);
                    level3 = living.f_19853_;
                    if (level3 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level3;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(harmLevel * 10.0f), 0.0, 0.0, 0.0, 0.25);
                    }
                }
                if ((double)(harmLevel = (float)EnvironmentalHandler.getPressureValue(living) / (float)EnvironmentalHandler.getEnvironmentalVolume(living)) > 0.1) {
                    EnvironmentalHandler.hurtEntity(living, EDamageSource.pressure(true, (int)harmLevel), harmLevel * 0.05f * 5.0f * living.m_21233_());
                    EnvironmentalHandler.postPressureEffect(harmLevel, living);
                    level3 = living.f_19853_;
                    if (level3 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level3;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(harmLevel * 10.0f), 0.0, 0.0, 0.0, 0.25);
                    }
                }
                if ((double)(harmLevel = (float)EnvironmentalHandler.getIonizeValue(living) / (float)EnvironmentalHandler.getEnvironmentalVolume(living)) > 0.1) {
                    EnvironmentalHandler.hurtEntity(living, EDamageSource.ionize(true, (int)harmLevel), harmLevel * 0.05f * living.m_21233_());
                    EnvironmentalHandler.postIonizeEffect(harmLevel, living);
                    level3 = living.f_19853_;
                    if (level3 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level3;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)etshtinkerParticleType.electric.get()), living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), (int)(harmLevel * 10.0f), 0.0, 0.0, 0.0, 0.25);
                    }
                }
            }
        }
    }

    public static void postScorchEffect(float harmLevel, LivingEntity living) {
        living.m_20254_((int)(20.0f * harmLevel));
    }

    public static void postFrozenEffect(float harmLevel, LivingEntity living) {
        living.m_146917_((int)(20.0f * harmLevel));
        living.f_146809_ = true;
    }

    public static void postPressureEffect(float harmLevel, LivingEntity living) {
    }

    public static void postIonizeEffect(float harmLevel, LivingEntity living) {
    }

    public static void updateEnvironmentalAttribute(LivingEntity living) {
    }

    public static void addScorchValue(@NotNull LivingEntity living, int amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128405_(SCORCH_AMOUNT, nbt.m_128451_(SCORCH_AMOUNT) + amount);
    }

    public static void addFrozenValue(@NotNull LivingEntity living, int amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128405_(FROZEN_AMOUNT, nbt.m_128451_(FROZEN_AMOUNT) + amount);
    }

    public static void addIonizeValue(@NotNull LivingEntity living, int amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128405_(IONIZE_AMOUNT, nbt.m_128451_(IONIZE_AMOUNT) + amount);
    }

    public static void addPressureValue(@NotNull LivingEntity living, int amount) {
        CompoundTag nbt = living.getPersistentData();
        nbt.m_128405_(PRESSURE_AMOUNT, nbt.m_128451_(PRESSURE_AMOUNT) + amount);
    }

    public static int getScorchValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128451_(SCORCH_AMOUNT);
    }

    public static int getFrozenValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128451_(FROZEN_AMOUNT);
    }

    public static int getIonizeValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128451_(IONIZE_AMOUNT);
    }

    public static int getPressureValue(@NotNull LivingEntity living) {
        return living.getPersistentData().m_128451_(PRESSURE_AMOUNT);
    }

    public static boolean isEnvironmentalSafe(@NotNull LivingEntity living) {
        return EnvironmentalHandler.getScorchValue(living) < 0 && EnvironmentalHandler.getFrozenValue(living) < 0 && EnvironmentalHandler.getIonizeValue(living) < 0 && EnvironmentalHandler.getPressureValue(living) < 0;
    }

    public static int getEnvironmentalVolume(@NotNull LivingEntity living) {
        return 100;
    }

    public static float getIonizeResistance(LivingEntity living) {
        float resist = 0.0f;
        AttributeInstance instance = living.m_21051_((Attribute)CtiAttributes.IONIZE_RESISTANCE.get());
        if (instance != null) {
            resist += (float)instance.m_22135_();
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentalHandler.getCapability((ICapabilityProvider)stack, ctiCapabilities.ELECTRIC_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IElectricShielding)shielding.get()).getElectricShieldinng();
                continue;
            }
            if (!stack.m_204131_().toList().contains(CtiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    public static float getScorchResistance(LivingEntity living) {
        float resist = 0.0f;
        AttributeInstance instance = living.m_21051_((Attribute)CtiAttributes.SCORCHED_RESISTANCE.get());
        if (instance != null) {
            resist += (float)instance.m_22135_();
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentalHandler.getCapability((ICapabilityProvider)stack, ctiCapabilities.SCORCH_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IScorchShielding)shielding.get()).getScorchShieldinng();
                continue;
            }
            if (stack.m_204131_().toList().contains(CtiTagkey.PRESSURE_MINOR)) {
                resist += 1.0f;
                continue;
            }
            if (!stack.m_204131_().toList().contains(CtiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    public static float getFrozenResistance(LivingEntity living) {
        float resist = 0.0f;
        AttributeInstance instance = living.m_21051_((Attribute)CtiAttributes.FROZEN_RESISTANCE.get());
        if (instance != null) {
            resist += (float)instance.m_22135_();
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentalHandler.getCapability((ICapabilityProvider)stack, ctiCapabilities.FREEZE_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IFreezeShielding)shielding.get()).getFreezeShieldinng();
                continue;
            }
            if (stack.m_204131_().toList().contains(CtiTagkey.PRESSURE_MINOR)) {
                resist += 0.5f;
                continue;
            }
            if (!stack.m_204131_().toList().contains(CtiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    public static float getPressureResistance(LivingEntity living) {
        float resist = 0.0f;
        AttributeInstance instance = living.m_21051_((Attribute)CtiAttributes.PRESSURE_RESISTANCE.get());
        if (instance != null) {
            resist += (float)instance.m_22135_();
        }
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = living.m_6844_(slot);
            Optional shielding = EnvironmentalHandler.getCapability((ICapabilityProvider)stack, ctiCapabilities.PRESSURE_SHIELDING, null).resolve();
            if (shielding.isPresent()) {
                resist += ((IPressureShielding)shielding.get()).getPressureShielding();
                continue;
            }
            if (stack.m_204131_().toList().contains(CtiTagkey.PRESSURE_MINOR)) {
                resist += 0.5f;
                continue;
            }
            if (!stack.m_204131_().toList().contains(CtiTagkey.ENVIRONMENT_ADV)) continue;
            resist += 10.0f;
        }
        return resist;
    }

    @NotNull
    public static <T> LazyOptional<T> getCapability(@Nullable ICapabilityProvider provider, @Nullable Capability<T> cap, @Nullable Direction side) {
        if (provider == null || cap == null || !cap.isRegistered()) {
            return LazyOptional.empty();
        }
        return provider.getCapability(cap, side);
    }
}

